﻿var completedSurveyPage = {
    clientId: 0,
    selectedLicenseId: function () {
        return $(".h-licensePeriodCaseFilter").val();
    },
    exportGridData: function () {
        var tableParams = $(".h-completedSurveyTable").a4datatable("getTableParams");
        var columns = $(".h-completedSurveyTable").a4datatable("getVisibleColumns");
        a4.showBusyBox();
        a4.callServerMethod(a4.getAction("ExportCompletedCasesToCSV", "Licenses", "Settings"), { clientId: completedSurveyPage.clientId, tableParams: tableParams }, function (result) {
            a4.hideBusyBox();
            window.location = a4.getAction("DownloadFile", "Licenses", "Settings", { fileName: result });
        },
        function (error) {
            a4.onAjaxPageMethodError(error);
        });
    },
    bindEvents: function () {
        $('.h-export-data').on('click', function() {
            completedSurveyPage.exportGridData();
        }); 
    },
    initializeDataTable: function () {
        $(".h-completedSurveyTable").a4datatable({
            advancedFilter: true,
            height: "full",
            defaultSorting: "SurveyId",
            stateKey: "CompletedCases",
            ajaxParams: { licenseId: completedSurveyPage.selectedLicenseId(), clientId: completedSurveyPage.clientId },
            ajaxAction: a4.getAction("GetCompletedCases", "Licenses", "Settings"),
            columns: [
                { "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id" },
                { "Title": resources.SurveyId, "Data": "SurveyId", "Class": "id" }, 
                { "Title": resources.licenseId, "Data": "LicenseId", "Class": "v-name" },
                { "Title": resources.SurveyName, "Data": "SurveyName" },
                { "Title": resources.CompletedDate, "Data": "CompletedDate", "Type": "datetime" },
                { "Title": resources.Date, "Data": "LicenseCounterType", "Type": "enum", "EnumType": "LicenseCounterType" },
                { "Title": resources.SurveyLicenseCompletedReason, "Data": "SurveyLicenseCompletedReason", "Type": "enum", "EnumType": "SurveyLicenseCompletedReason"},
                { "Title": resources.RespondentId, "Data": "RespondentId" }
            ],
            localizableTexts: { "Search": resources.SearchCompletedCases }
        });
    }
}
$(document).ready(function () {
        completedSurveyPage.clientId = $("#ClientId").val();
        completedSurveyPage.bindEvents();
        completedSurveyPage.initializeDataTable();
});